#include <iostream>
#include <iomanip>
#include "attack.h"
#include "piece.h"
#include "squares.h"


const uint wPbit = 1;
const uint bPbit = wPbit*2;
const uint Nbit = bPbit*2;
const uint Bbit = Nbit*2;
const uint Rbit = Bbit*2;
const uint Qbit = Rbit*2;
const uint Kbit = Qbit*2;

const uint pcebits[] =
{
  0,wPbit,bPbit,Nbit,Nbit,Bbit,Bbit,Rbit,Rbit,Qbit,Qbit,Kbit,Kbit
};

const uint slidersquares = 7;
const uint nonslidersquares = 1;


const uint nonattsliders[numcolours][3] =
{
     {pwK,pwN,pwP},
     {pbK,pbN,pbP}
};

unsigned int bitsfromdelta[256];
int stepfromdelta[256];

void init_attack_tables()
{
  const int *movedir = NULL;
  uint piece;
  uint slidenum;
  uint slide;
  int delta;
  int finaldelta;

  //major pieces first (non pawns)
  for(piece = pwN; piece <= pbK; ++piece)
  {
    ASS(piecegood(piece));
    ASS(isslide[piece]==1 || isslide[piece]==0);
    if(isslide[piece]) slidenum = slidersquares;
    else slidenum = nonslidersquares;
    ASS(slidenum==7 || slidenum==1);
    for(movedir = dirPieces[piece]; *movedir ; movedir++)
    {
       delta = *movedir;
       for(slide = 0; slide < slidenum; ++slide)
       {
          finaldelta = delta + (delta * slide)+128;
          ASS(finaldelta>=0&&finaldelta<256);
          bitsfromdelta[finaldelta] |= pcebits[piece];
          stepfromdelta[finaldelta] = delta;
       }
    }
  }

  uint i;
  for(piece = pwP; piece <= pbP; ++piece)
  {
    for(i = 0; i < 2; ++i)
    {
      delta = dirPawn[piece][i];
      finaldelta = delta + 128;
      ASS(finaldelta>=0&&finaldelta<256);
      bitsfromdelta[finaldelta] |= pcebits[piece];
      stepfromdelta[finaldelta] = delta;
    }
  }

}

//see if the current side "side" is in check
bool incheck(cBoard &b, cMaterial &m, const uint side)
{
    ASS(side==cW||side==cB);
    return isattack(b, m, (side^1), m.getkingsq(side));
}

//is square attacked by side
bool isattack(cBoard &pboard, cMaterial &material, const uint &side, const uint target)
{
 // cout<<" looking to see if "<<printsquare(target)<<" is attacked by "<<side;
  int delta, step;
  uint iter, i;
  uint pcenum;
  uint *board = pboard.p2board();
  uint piece;
  uint sq;

  ASS(side==cW||side==cB);
  ASS(onbrd(target));

  //sliders
  for(i = 0; i < 3; ++i)
     {
       piece = sliders[side][i];
       ASS(piecegood(piece));
       ASS(isslide[piece]==1);
       pcenum = material.getpcenum(piece);
       ASS(pcenum<maxpiecenum);
       while(pcenum)
       {
         sq = material.getpcesq(piece, pcenum);
         ASS(onbrd(sq));
         ASS(board[sq]==piece);
         delta = target - sq + 128;
         ASS(delta>=0&&delta<256);
         if(pcebits[piece] & bitsfromdelta[delta])//could hit
         {
          step = stepfromdelta[delta];
          for(iter = sq+step; ;iter+=step)
          {
            if(iter==target) return true;
            if(board[iter]!=pE) break;
            if(iter&0x88) break;
          }
         }
         pcenum--;
       }
     }

     //pawns and knights and kings
     for(i = 0; i < 3; ++i)
     {
       piece = nonattsliders[side][i];
       ASS(piecegood(piece));
       ASS(!isslide[piece]);
       pcenum = material.getpcenum(piece);
       ASS(pcenum<maxpiecenum);
       while(pcenum)
       {
         sq = material.getpcesq(piece, pcenum);
         ASS(onbrd(sq));
         ASS(board[sq]==piece);
         delta = target - sq + 128;
         ASS(delta>=0&&delta<256);
         if(pcebits[piece] & bitsfromdelta[delta])//could hit
         {
          return true;
         }
         pcenum--;
       }
     }
     return false;
}

void printattboard(const uint piece, const uint sq)
{
    uint f = 0;
    int  r = 0;
    int delta,finaldelta;
    uint s;

    cout<<endl;

    for( r = 7; r>=0; r--)
    {
        for( f = 0; f<=7; ++f)
        {
           s = fr2sq(f,r);
           ASS(onbrd(s));

           if(s==sq) cout<<setw(3)<<".";
           else
           {
               delta = s - sq;
               finaldelta = delta + 128;
               if(pcebits[piece] & bitsfromdelta[finaldelta])
               cout<<setw(3)<<"y";
               else
               cout<<setw(3)<<".";
           }
        }
        cout<<endl;
    }
    cout<<endl;
}


void printsquaresatt(cBoard &pboard, cMaterial &material, const uint side)
{
    uint f = 0;
    int  r = 0;
    uint s;

    ASS(side==cW||side==cB);

    cout<<endl;

    for( r = 7; r>=0; r--)
    {
        for( f = 0; f<=7; ++f)
        {
           s = fr2sq(f,r);
           ASS(onbrd(s));

           if(isattack(pboard, material, side, s))
           {
             cout<<setw(3)<<"a";
           }
           else
           {
             cout<<setw(3)<<".";
           }
        }
        cout<<endl;
    }
    cout<<endl;
}
